pkgname <- "taRifx.geo"
source(file.path(R.home("share"), "R", "examples-header.R"))
options(warn = 1)
base::assign(".ExTimings", "taRifx.geo-Ex.timings", pos = 'CheckExEnv')
base::cat("name\tuser\tsystem\telapsed\n", file=base::get(".ExTimings", pos = 'CheckExEnv'))
base::assign(".format_ptime",
function(x) {
  if(!is.na(x[4L])) x[1L] <- x[1L] + x[4L]
  if(!is.na(x[5L])) x[2L] <- x[2L] + x[5L]
  options(OutDec = '.')
  format(x[1L:3L], digits = 7L)
},
pos = 'CheckExEnv')

### * </HEADER>
library('taRifx.geo')

base::assign(".oldSearch", base::search(), pos = 'CheckExEnv')
cleanEx()
nameEx("as.SpatialPolygons.bbox")
### * as.SpatialPolygons.bbox

flush(stderr()); flush(stdout())

base::assign(".ptime", proc.time(), pos = "CheckExEnv")
### Name: as.SpatialPolygons.bbox
### Title: Convert a bounding box to a SpatialPolygons object Bounding box
###   is first created (in lat/lon) then projected if specified
### Aliases: as.SpatialPolygons.bbox

### ** Examples

bb <- matrix(c(3,2,5,4),nrow=2)
rownames(bb) <- c("lon","lat")
colnames(bb) <- c('min','max')
as.SpatialPolygons.bbox( bb )



base::assign(".dptime", (proc.time() - get(".ptime", pos = "CheckExEnv")), pos = "CheckExEnv")
base::cat("as.SpatialPolygons.bbox", base::get(".format_ptime", pos = 'CheckExEnv')(get(".dptime", pos = "CheckExEnv")), "\n", file=base::get(".ExTimings", pos = 'CheckExEnv'), append=TRUE, sep="\t")
cleanEx()
nameEx("clipToExtent")
### * clipToExtent

flush(stderr()); flush(stdout())

base::assign(".ptime", proc.time(), pos = "CheckExEnv")
### Name: clipToExtent
### Title: Restrict to extent of a polygon Currently does the sloppy thing
###   and returns any object that has any area inside the extent polygon
### Aliases: clipToExtent

### ** Examples

set.seed(1)
P4S.latlon <- CRS("+proj=longlat +datum=WGS84")
ply <- SpatialPolygons(list(
   Polygons(list(Polygon(cbind(c(2,4,4,1,2),c(2,3,5,4,2)))), "s1"),
   Polygons(list(Polygon(cbind(c(5,4,2,5),c(2,3,2,2)))), "s2")
 ), proj4string=P4S.latlon)
pnt <- SpatialPoints( matrix(rnorm(100),ncol=2)+2, proj4string=P4S.latlon )
# Make bounding box as Spatial Polygon
bb <- matrix(c(3,2,5,4),nrow=2)
rownames(bb) <- c("lon","lat")
colnames(bb) <- c('min','max')
require(rgdal)
bbSP <- as.SpatialPolygons.bbox(bb, proj4stringTo=P4S.latlon )
# Clip to extent
plyClip <- clipToExtent( ply, bbSP )
pntClip <- clipToExtent( pnt, bbSP )
# Plot
plot( ply )
plot( pnt, add=TRUE )
plot( bbSP, add=TRUE, border="blue" )
plot( plyClip, add=TRUE, border="red")
plot( pntClip, add=TRUE, col="red", pch="o")



base::assign(".dptime", (proc.time() - get(".ptime", pos = "CheckExEnv")), pos = "CheckExEnv")
base::cat("clipToExtent", base::get(".format_ptime", pos = 'CheckExEnv')(get(".dptime", pos = "CheckExEnv")), "\n", file=base::get(".ExTimings", pos = 'CheckExEnv'), append=TRUE, sep="\t")
cleanEx()
nameEx("geocode")
### * geocode

flush(stderr()); flush(stdout())

base::assign(".ptime", proc.time(), pos = "CheckExEnv")
### Name: geocode
### Title: Geocode character vectors using online services
### Aliases: geocode geocode.data.frame geocode.default

### ** Examples

## Not run: 
##D geocode("3817 Spruce St, Philadelphia, PA 19104")
##D geocode("Philadelphia, PA")
##D dat <- data.frame(
##D  value=runif(3),
##D  address=c("3817 Spruce St, Philadelphia, PA 19104","Philadelphia, PA","Neverneverland")
##D )
##D geocode(dat)
## End(Not run)



base::assign(".dptime", (proc.time() - get(".ptime", pos = "CheckExEnv")), pos = "CheckExEnv")
base::cat("geocode", base::get(".format_ptime", pos = 'CheckExEnv')(get(".dptime", pos = "CheckExEnv")), "\n", file=base::get(".ExTimings", pos = 'CheckExEnv'), append=TRUE, sep="\t")
cleanEx()
nameEx("georoute")
### * georoute

flush(stderr()); flush(stdout())

base::assign(".ptime", proc.time(), pos = "CheckExEnv")
### Name: georoute
### Title: Find driving routes using online services
### Aliases: georoute georoute.default

### ** Examples

## Not run: 
##D georoute( c("3817 Spruce St, Philadelphia, PA 19104",
##D  "9000 Rockville Pike, Bethesda, Maryland 20892"), verbose=TRUE )
##D georoute( c("3817 Spruce St, Philadelphia, PA 19104",
##D  "Tulum, MX","9000 Rockville Pike, Bethesda, Maryland 20892"), returntype="distance" )
##D georoute( c("3817 Spruce St, Philadelphia, PA 19104",
##D  "9000 Rockville Pike, Bethesda, Maryland 20892"), verbose=TRUE, returntype="path" )
##D georoute( c("3817 Spruce St, Philadelphia, PA 19104",
##D  "9000 Rockville Pike, Bethesda, Maryland 20892"), verbose=TRUE, returntype="time" )
##D # Using lat/lon
##D xmat <- rbind(
##D  geocode( "3817 Spruce St, Philadelphia, PA 19104" ),
##D  geocode( "9000 Rockville Pike, Bethesda, Maryland 20892" )
##D )
##D colnames(xmat) <- c( 'lat', 'lon' )
##D georoute( xmat, verbose=TRUE, returntype = c("distance","distanceUnit") )
## End(Not run)



base::assign(".dptime", (proc.time() - get(".ptime", pos = "CheckExEnv")), pos = "CheckExEnv")
base::cat("georoute", base::get(".format_ptime", pos = 'CheckExEnv')(get(".dptime", pos = "CheckExEnv")), "\n", file=base::get(".ExTimings", pos = 'CheckExEnv'), append=TRUE, sep="\t")
cleanEx()
nameEx("interpolateAndApplyWithinSpatial")
### * interpolateAndApplyWithinSpatial

flush(stderr()); flush(stdout())

base::assign(".ptime", proc.time(), pos = "CheckExEnv")
### Name: interpolateAndApplyWithinSpatial
### Title: Generic function to interpolate from a polygon to points lying
###   inside it This function was designed to solve the following problem.
###   Suppose you have counts of the number of entities inside a polygon
###   (N).  To compute distances to a point, you might take the distance
###   from the polygon centroid.  But this is too simplistic-it discards
###   the positional uncertainty inherent in not knowing the exact location
###   of each entity which makes up the count.  Instead, we repeatedly
###   sample N points from the census block group centroids which lie
###   within our polygon, weight them by their population, and compute
###   distances from there.
### Aliases: interpolateAndApplyWithinSpatial

### ** Examples

# Not run because too time-consuming
## Not run: 
##D require(fields)
##D require(rgdal)
##D distanceMatrix <- function( points1, points2, dist.fn=rdist.earth ) {
##D  cat( "Generating distance matrix for ",length(points1)," by ", length(points2), " matrix.\n" )
##D  if(!is.na(proj4string(points1))) {
##D    points1 <- spTransform( points1, CRS("+proj=longlat +datum=WGS84") )
##D  }
##D  if(!is.na(proj4string(points2))) {
##D    points2 <- spTransform( points2, CRS("+proj=longlat +datum=WGS84") )
##D  }
##D  dist.fn( coordinates(points1), coordinates(points2) )
##D }
##D # One option: Use the apply functionality
##D dist <- interpolateAndApplyWithinSpatial(
##D  crude=polySP, fine=pointSP,
##D  FUN=distanceMatrix,
##D  nSampleCol="z", samplesize=25,
##D  points2=pointSP2, simplify=TRUE
##D )
##D # Dist now is a list of 3 matrices, each with dimensions: N x length(pointSP2) x samplesize
##D # Each matrix represents N entities imputed from a single polygon,
##D #   so we can actually simplify further
##D library(abind)
##D distmat <- do.call( Curry(abind, along=1), dist )
##D mindist <- apply( distmat, 3, function(x) { # For each realization of the 'world'
##D   apply( x,  )
##D } )
## End(Not run) # end of dontrun



base::assign(".dptime", (proc.time() - get(".ptime", pos = "CheckExEnv")), pos = "CheckExEnv")
base::cat("interpolateAndApplyWithinSpatial", base::get(".format_ptime", pos = 'CheckExEnv')(get(".dptime", pos = "CheckExEnv")), "\n", file=base::get(".ExTimings", pos = 'CheckExEnv'), append=TRUE, sep="\t")
cleanEx()
nameEx("interpolatePolyPoint")
### * interpolatePolyPoint

flush(stderr()); flush(stdout())

base::assign(".ptime", proc.time(), pos = "CheckExEnv")
### Name: interpolatePolyPoint
### Title: Interpolate points from polygon SPDF This function returns
###   (weighted) sample points in fine for every polygon in crude. Thus
###   running it repeatedly gives you useful variation that reflects the
###   interpolation uncertainty.
### Aliases: interpolatePolyPoint

### ** Examples

## Not run: 
##D replicate( 10, interpolatePolyPoint(
##D   crude=polySP, fine=pointSP,
##D   weightCol="pop", nSampleCol="z",
##D   replace=TRUE, verbose=TRUE ),
##D simplify=FALSE )
## End(Not run)



base::assign(".dptime", (proc.time() - get(".ptime", pos = "CheckExEnv")), pos = "CheckExEnv")
base::cat("interpolatePolyPoint", base::get(".format_ptime", pos = 'CheckExEnv')(get(".dptime", pos = "CheckExEnv")), "\n", file=base::get(".ExTimings", pos = 'CheckExEnv'), append=TRUE, sep="\t")
cleanEx()
nameEx("simpledist")
### * simpledist

flush(stderr()); flush(stdout())

base::assign(".ptime", proc.time(), pos = "CheckExEnv")
### Name: simpledist
### Title: Cartesian distance between points
### Aliases: simpledist

### ** Examples

points <- matrix(c(0,3,0,4),nrow=2)
simpledist(points)



base::assign(".dptime", (proc.time() - get(".ptime", pos = "CheckExEnv")), pos = "CheckExEnv")
base::cat("simpledist", base::get(".format_ptime", pos = 'CheckExEnv')(get(".dptime", pos = "CheckExEnv")), "\n", file=base::get(".ExTimings", pos = 'CheckExEnv'), append=TRUE, sep="\t")
### * <FOOTER>
###
options(digits = 7L)
base::cat("Time elapsed: ", proc.time() - base::get("ptime", pos = 'CheckExEnv'),"\n")
grDevices::dev.off()
###
### Local variables: ***
### mode: outline-minor ***
### outline-regexp: "\\(> \\)?### [*]+" ***
### End: ***
quit('no')
